using System;

namespace gov.va.med.vbecs.Common
{

	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	/// <Developers>
	/// 	<Developer>Greg Lohse</Developer>
	/// </Developers>
	/// <SiteName>Hines OIFO</SiteName>
	/// <CreationDate>6/9/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	/// <summary>
	/// Action Item class is used to hold an error code and a message.
	/// Designed and originally created for use with the Modify Units use cases (UC24-UC26)
	/// This class is free for all to use.
	/// </summary>

	#endregion

	public class ActionItem
	{

		#region Variables

		
		/// <summary>
		/// _action
		/// </summary>
		private Common.VerifyAction _action = Common.VerifyAction.Unknown;

		/// <summary>
		/// _message
		/// </summary>
		private string _message;


		#endregion


		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="498"> 
		///		<ExpectedInput>Action - Common.VerifyAction, Message - string</ExpectedInput>
		///		<ExpectedOutput>VerifyAction object</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="499"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// VerifyAction class constructor
		/// </summary>
		/// <param name="action">Verify Action enum</param>
		/// <param name="message">Display Message</param>
		public ActionItem(Common.VerifyAction action, string message)
		{
			this._action = action;
			this._message = message;
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="507"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Common.VerifyAction value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="508"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets verify action
		/// </summary>
		public Common.VerifyAction ReturnAction
		{
			get
			{
				return _action;
			}
		}

		///<Developers>
		///<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/10/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="511"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>String value</ExpectedOutput>
		///</Case>
		///
		///<Case type="1" testid ="512"> 
		///		<ExpectedInput>NA</ExpectedInput>
		///		<ExpectedOutput>NA</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Gets display message
		/// </summary>
		public string Message
		{
			get
			{
				return _message;
			}
		}

	}
}
